using Harmony;
using Verse;

namespace Therapy.Patches
{
    internal static class PawnRenderer_Patch
    {
        // To allow pawns to lay correctly on couches
        [HarmonyPatch(typeof(PawnRenderer), "LayingFacing")]
        public class LayingFacing
        {
            [HarmonyPrefix]
            public static bool Replacement(ref PawnRenderer __instance, ref Rot4 __result)
            {
                var pawn = Traverse.Create(__instance).Field("pawn").GetValue<Pawn>();
                if (pawn == null) return true;

                var couch = pawn.CurrentCouch();
                if (couch != null)
                {
                    __result = couch.Rotation.Opposite;
                    return false;
                }

                return true;
            }
        }
    }
}